close all;
clear all;
%Random state
rng('default')
s=rng;
%Data
n=1000;
niter=100;
X=betarnd(5,5,[niter,n]);
writematrix(X,sprintf('%s_%d%s','original_n',n,'.xlsx'))
%X=betarnd(1,5,[1,n]).^(0.25);
beta=3;
t=0:0.01:1;
a=5;
b=5;
pdf=betapdf(t,a,b);
%pdf=5*5*(t.^(a-1)).*(1-t.^a).^(b-1);
%Privacy
mu=0.5;
alpha=log(normcdf(0.5*mu)/(1-normcdf(0.5*mu)));
%r2=35;
func=(diff(diff(diff(pdf)))/0.01^(3)).^2;
%func=@(x) (a*b*(x.^(a-2)).*((1-x.^a).^(b-2)).*((a-1)-(a*b-1)*x.^(a-1))).^2;
r2=trapz(func)/length(func);

%Estimation
niter=100;

err_nonpriv=zeros([1,niter]);
err_Lap_ext=zeros([1,niter]);
err_Lap_2=zeros([1,niter]);
err_Lap_4=zeros([1,niter]);
err_Lap_8=zeros([1,niter]);
err_Lap_16=zeros([1,niter]);
err_ext=zeros([1,niter]);
err_2=zeros([1,niter]);
err_4=zeros([1,niter]);
err_8=zeros([1,niter]);
err_16=zeros([1,niter]);
err_gdp=zeros([1,niter]);
err_gdp_2=zeros([1,niter]);

alpha_exact_den=zeros([niter,length(t)]);
alpha_2_den=zeros([niter,length(t)]);
alpha_4_den=zeros([niter,length(t)]);
alpha_8_den=zeros([niter,length(t)]);
alpha_16_den=zeros([niter,length(t)]);
nonpriv_den=zeros([niter,length(t)]);
Lap_exact_den=zeros([niter,length(t)]);
Lap_2_den=zeros([niter,length(t)]);
Lap_4_den=zeros([niter,length(t)]);
Lap_8_den=zeros([niter,length(t)]);
Lap_16_den=zeros([niter,length(t)]);
GDP_den=zeros([niter,length(t)]);
GDP_den_2=zeros([niter,length(t)]);
for i=1:niter
    alpha_exact_den(i,:)=alpha_DP_density_est(s,alpha,beta,r2,X(i,:),t);
    alpha_2_den(i,:)=alpha_DP_density_est(s,alpha*2,beta,r2,X(i,:),t);
    alpha_4_den(i,:)=alpha_DP_density_est(s,alpha*4,beta,r2,X(i,:),t);
    alpha_8_den(i,:)=alpha_DP_density_est(s,alpha*8,beta,r2,X(i,:),t);
    alpha_16_den(i,:)=alpha_DP_density_est(s,alpha*16,beta,r2,X(i,:),t);
    nonpriv_den(i,:)=nonpriv_density_est(beta,r2,X(i,:),t);
    Lap_exact_den(i,:)=LapDP_density_est(s,alpha,beta,r2,X(i,:),t);
    Lap_2_den(i,:)=LapDP_density_est(s,alpha*2,beta,r2,X(i,:),t);
    Lap_4_den(i,:)=LapDP_density_est(s,alpha*4,beta,r2,X(i,:),t);
    Lap_8_den(i,:)=LapDP_density_est(s,alpha*8,beta,r2,X(i,:),t);
    Lap_16_den(i,:)=LapDP_density_est(s,alpha*16,beta,r2,X(i,:),t);
    GDP_den(i,:)=GDP_density_est(s,mu,beta,r2,X(i,:),t);
    GDP_den_2(i,:)=GDP_density_est(s,mu*2,beta,r2,X(i,:),t);
    err_nonpriv(i)=mean((nonpriv_den(i,:)-pdf).^2);
    err_Lap_ext(i)=mean((Lap_exact_den(i,:)-pdf).^2);
    err_Lap_2(i)=mean((Lap_2_den(i,:)-pdf).^2);
    err_Lap_4(i)=mean((Lap_4_den(i,:)-pdf).^2);
    err_Lap_8(i)=mean((Lap_8_den(i,:)-pdf).^2);
    err_Lap_16(i)=mean((Lap_16_den(i,:)-pdf).^2);
    err_ext(i)=mean((alpha_exact_den(i,:)-pdf).^2);
    err_2(i)=mean((alpha_2_den(i,:)-pdf).^2);
    err_4(i)=mean((alpha_4_den(i,:)-pdf).^2);
    err_8(i)=mean((alpha_8_den(i,:)-pdf).^2);
    err_16(i)=mean((alpha_16_den(i,:)-pdf).^2);
    err_gdp(i)=mean((GDP_den(i,:)-pdf).^2);
    err_gdp_2(i)=mean((GDP_den_2(i,:)-pdf).^2);
end
Estimation=[nonpriv_den;alpha_exact_den;alpha_2_den;alpha_4_den;alpha_8_den;alpha_16_den;Lap_exact_den;Lap_2_den;Lap_4_den;Lap_8_den;Lap_16_den;GDP_den;GDP_den_2;];
filename = sprintf('%s_%d%s','n_new_',n,'.xlsx');
writematrix(Estimation,filename)

[mean(err_nonpriv),std(err_nonpriv)]
[mean(err_ext),std(err_ext)]
[mean(err_2),std(err_2)]
[mean(err_4),std(err_4)]
[mean(err_8),std(err_8)]
[mean(err_16),std(err_16)]
[mean(err_gdp),std(err_gdp)]
[mean(err_gdp_2),std(err_gdp_2)]
